<?php
// Start session
session_start();

require_once __DIR__ . '/../../includes/config.php';

// Get user data from session
$udata = null;
$session_value = null;

if (isset($_SESSION['username']) && !empty($_SESSION['username'])) {
    $session_value = $_SESSION['username'];
} elseif (isset($_SESSION['phone']) && !empty($_SESSION['phone'])) {
    $session_value = $_SESSION['phone'];
} elseif (isset($_SESSION['user_phone']) && !empty($_SESSION['user_phone'])) {
    $session_value = $_SESSION['user_phone'];
} elseif (isset($_SESSION['mobile']) && !empty($_SESSION['mobile'])) {
    $session_value = $_SESSION['mobile'];
}

if ($session_value) {
    $session_escaped = mysqli_real_escape_string($ahk_conn, $session_value);
    // Try by phone field first
    $user_query = mysqli_query($ahk_conn, "SELECT * FROM users WHERE phone='$session_escaped' LIMIT 1");
    if ($user_query && mysqli_num_rows($user_query) > 0) {
        $udata = mysqli_fetch_assoc($user_query);
    } else {
        // Try by username field
        $user_query = mysqli_query($ahk_conn, "SELECT * FROM users WHERE username='$session_escaped' LIMIT 1");
        if ($user_query && mysqli_num_rows($user_query) > 0) {
            $udata = mysqli_fetch_assoc($user_query);
        }
    }
}

if (!$udata) {
    // Redirect to login if user not found
    header('Location: ../login.php');
    exit;
}

$pdfData = '';
$application_no = '';

if (isset($_POST['docno'])) {
    $docno = trim($_POST['docno']);
    $doctype = $_POST['doctype'];
    $type = isset($_POST['type']) ? $_POST['type'] : 'old';
    $application_no = "RAT_" . rand(100000, 999999);

    // Remove spaces from Aadhaar number (format: 1234 5678 9012 -> 123456789012)
    if ($doctype === 'aadhar') {
        $docno = preg_replace('/\s+/', '', $docno);
        // Validate Aadhaar (12 digits)
        if (!preg_match('/^[0-9]{12}$/', $docno)) {
            echo "<script>
                Swal.fire(
                    'Invalid Aadhaar Number',
                    'Please enter exactly 12 digits',
                    'error'
                );
            </script>";
            $docno = '';
        }
    } else {
        // Remove spaces from Ration number too
        $docno = preg_replace('/\s+/', '', $docno);
    }

    if (empty($docno)) {
        // Error already shown or docno is empty
    } else {
        // Get service fee from pricing table
        $price = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT * FROM pricing WHERE service_name='ration_pdf_flx_print_fee' "));
        $fee = isset($price['price']) ? $price['price'] : 15; // Default ₹15 if not found
        $username = $udata['phone'];
        $wallet_amount = $udata['balance'];

        if ($wallet_amount >= $fee) {
            $debit_fee = $wallet_amount - $fee;
            
            // API CALL based on document type
            $api_key = "enter api key"; // Admin API Key
            
            if ($doctype === 'aadhar') {
                // Aadhaar to Ration PDF API
                $url = "https://lostdata.co.in/api/aadhar-to-ration-pdf.php?uid_no=" . urlencode($docno) . "&api_key=" . urlencode($api_key);
            } else {
                // Ration Number to PDF API
                $url = "https://lostdata.co.in/api/ration-pdf.php?rasan_no=" . urlencode($docno) . "&type=" . urlencode($type) . "&api_key=" . urlencode($api_key);
            }

            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 60,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_USERAGENT => 'Mozilla/5.0'
            ));

            $response = curl_exec($curl);
            $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            $curl_error = curl_error($curl);
            curl_close($curl);
            
            // Check for curl errors
            if ($curl_error) {
                echo "<script>
                    Swal.fire(
                        'Connection Error',
                        '" . addslashes($curl_error) . "',
                        'error'
                    );
                </script>";
                $pdfData = '';
            } elseif ($http_code != 200) {
                echo "<script>
                    Swal.fire(
                        'API Error',
                        'HTTP Error: $http_code',
                        'error'
                    );
                </script>";
                $pdfData = '';
            } else {
                // Check if response is direct PDF
                $is_pdf = (substr($response, 0, 4) === '%PDF');
                
                if ($is_pdf) {
                    // Direct PDF received - convert to base64
                    $pdfData = base64_encode($response);
                } else {
                    // Try to parse as JSON
                    $resdata = json_decode($response, true);
                    
                    if ($resdata && isset($resdata['success']) && $resdata['success'] === true) {
                        // Check for PDF in different possible locations
                        if (isset($resdata['data']['pdf_base64'])) {
                            $pdfData = $resdata['data']['pdf_base64'];
                        } elseif (isset($resdata['file'])) {
                            $pdfData = $resdata['file'];
                        } elseif (isset($resdata['pdf_base64'])) {
                            $pdfData = $resdata['pdf_base64'];
                        } else {
                            $error_msg = isset($resdata['message']) ? $resdata['message'] : 'PDF data not found in API response';
                            echo "<script>
                                Swal.fire(
                                    '" . addslashes($error_msg) . "',
                                    'Ration Not Found',
                                    'warning'
                                );
                            </script>";
                            $pdfData = '';
                        }
                    } else {
                        $error_msg = 'Unknown error';
                        if ($resdata && isset($resdata['message'])) {
                            $error_msg = $resdata['message'];
                        } elseif ($resdata && isset($resdata['error'])) {
                            $error_msg = $resdata['error'];
                        }
                        echo "<script>
                            Swal.fire(
                                '" . addslashes($error_msg) . "',
                                'Ration Not Found',
                                'warning'
                            );
                        </script>";
                        $pdfData = '';
                    }
                }

                // If we have PDF data, deduct wallet and save
                if (!empty($pdfData)) {
                    $debit = mysqli_query($ahk_conn, "UPDATE users SET balance='$debit_fee' WHERE phone='$username'");
                    if ($debit) {
                        // Add wallet history
                        $purpose = mysqli_real_escape_string($ahk_conn, ($doctype === 'aadhar' ? 'Aadhaar' : 'Ration') . " to Ration PDF Download - " . ($doctype === 'aadhar' ? 'Aadhaar' : 'Ration') . ": $docno (₹$fee)");
                        $history_query = mysqli_query($ahk_conn, "INSERT INTO wallethistory (userid, amount, balance, purpose, status, type, date) VALUES ('$username', '$fee', '$debit_fee', '$purpose', '1', 'Debit', NOW())");
                        
                        // Insert into rasn_print table (if exists)
                        $insert = mysqli_query($ahk_conn, "INSERT INTO rasn_print (application_no, username, rasan_no, status, fee, front, back, pdf) VALUES ('$application_no','$username','$docno','success', '$fee', '$pdfData','$pdfData','$pdfData')");

                        if ($insert) {
                            echo "<script>
                                Swal.fire(
                                    'Success',
                                    'Ration PDF generated successfully!',
                                    'success'
                                );
                            </script>";
                        } else {
                            // Even if insert fails, show success if wallet was deducted
                            echo "<script>
                                Swal.fire(
                                    'Success',
                                    'Ration PDF generated successfully!',
                                    'success'
                                );
                            </script>";
                        }
                    }
                }
            }
        } else {
            echo "<script>
                Swal.fire(
                    'Oops!',
                    'Wallet Balance Insufficient! Required ₹$fee | Available ₹" . number_format($wallet_amount, 2) . "',
                    'error'
                );
                setTimeout(() => {
                    window.location.href = 'wallet.php';
                }, 2000);
            </script>";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ration PDF Download</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .main-container {
            max-width: 1200px;
            margin: 0 auto;
        }
        .service-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            overflow: hidden;
            margin-bottom: 30px;
        }
        .service-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 40px 20px;
            text-align: center;
        }
        .service-icon {
            width: 100px;
            height: 100px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            border: 5px solid rgba(255, 255, 255, 0.3);
        }
        .service-icon i {
            font-size: 50px;
            color: white;
        }
        .service-title {
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 10px;
        }
        .service-subtitle {
            font-size: 16px;
            opacity: 0.9;
            margin-bottom: 20px;
        }
        .service-fee {
            display: inline-block;
            background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
            color: white;
            padding: 10px 30px;
            border-radius: 30px;
            font-weight: 600;
            font-size: 18px;
            box-shadow: 0 5px 15px rgba(245, 158, 11, 0.4);
        }
        .wallet-info {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            padding: 20px;
            border-radius: 15px;
            margin: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 5px 15px rgba(16, 185, 129, 0.3);
        }
        .wallet-info .balance-label {
            font-size: 16px;
            opacity: 0.9;
        }
        .wallet-info .balance-amount {
            font-size: 24px;
            font-weight: 700;
        }
        .form-container {
            padding: 30px;
        }
        .form-label {
            font-weight: 600;
            color: #1e293b;
            margin-bottom: 8px;
            font-size: 15px;
        }
        .form-control, .form-select {
            height: 50px;
            border-radius: 12px;
            border: 2px solid #e2e8f0;
            padding: 12px 16px;
            font-size: 15px;
            transition: all 0.3s ease;
        }
        .form-control:focus, .form-select:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 4px rgba(102, 126, 234, 0.1);
            outline: none;
        }
        .btn-download {
            width: 100%;
            height: 55px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 12px;
            font-weight: 600;
            font-size: 17px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            transition: all 0.3s ease;
            margin-top: 20px;
        }
        .btn-download:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(102, 126, 234, 0.4);
            color: white;
        }
        .preview-container {
            padding: 30px;
            border-left: 1px solid #e2e8f0;
        }
        .preview-title {
            text-align: center;
            color: #1e293b;
            margin-bottom: 20px;
            font-weight: 600;
        }
        .preview-box {
            border: 2px dashed #667eea;
            border-radius: 15px;
            padding: 20px;
            text-align: center;
            min-height: 400px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            background: #f8fafc;
        }
        .preview-icon {
            font-size: 60px;
            color: #94a3b8;
            margin-bottom: 20px;
        }
        .info-box {
            background: #f8fafc;
            border-left: 4px solid #667eea;
            padding: 20px;
            border-radius: 10px;
            margin-top: 20px;
        }
        .digit-counter {
            text-align: right;
            font-size: 12px;
            color: #64748b;
            margin-top: 5px;
        }
        .digit-counter.warning {
            color: #f59e0b;
        }
        .digit-counter.success {
            color: #10b981;
        }
        .digit-counter.error {
            color: #ef4444;
        }
        .nav-buttons {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
        }
        @media (max-width: 768px) {
            .preview-container {
                border-left: none;
                border-top: 1px solid #e2e8f0;
                margin-top: 20px;
                padding-top: 30px;
            }
        }
    </style>
</head>
<body>

<div class="main-container">
    <!-- Navigation Buttons -->
    <div class="nav-buttons">
        <a href="javascript:history.back()" class="btn btn-outline-light">
            <i class="fas fa-arrow-left"></i> Back
        </a>
    </div>
    
    <!-- Main Service Card -->
    <div class="service-card">
        <!-- Service Header -->
        <div class="service-header">
            <div class="service-icon">
                <i class="fas fa-file-pdf"></i>
            </div>
            <h1 class="service-title">Ration PDF Download</h1>
            <p class="service-subtitle">Download ration card PDF using Aadhaar or Ration Number</p>
            <div class="service-fee">₹<?php 
                $price = mysqli_fetch_assoc(mysqli_query($ahk_conn,"SELECT price FROM pricing WHERE service_name='ration_pdf_flx_print_fee'")); 
                $display_fee = isset($price['price']) ? $price['price'] : 15;
                echo $display_fee;
            ?> Only</div>
        </div>
        
        <div class="row">
            <!-- Left Column: Form -->
            <div class="col-lg-6">
                <div class="form-container">
                    <!-- Wallet Info -->
                    <div class="wallet-info">
                        <span class="balance-label">
                            <i class="fas fa-wallet"></i> Your Wallet Balance
                        </span>
                        <span class="balance-amount">
                            ₹<?php 
                                if ($udata && isset($udata['balance'])) {
                                    echo number_format($udata['balance'], 2);
                                } else {
                                    echo "0.00";
                                }
                            ?>
                        </span>
                    </div>
                    
                    <!-- Form -->
                    <form method="POST" id="downloadForm">
                        <div class="mb-4">
                            <label class="form-label">
                                <i class="fas fa-file-alt"></i> Document Type
                            </label>
                            <select class="form-select" required name="doctype" id="doctype">
                                <option value="">Select Document Type</option>
                                <option value="aadhar">Aadhaar Number</option>
                                <option value="ration">Ration Number</option>
                            </select>
                        </div>
                        
                        <div class="mb-4">
                            <label class="form-label" id="docnoLabel">
                                <i class="fas fa-id-card"></i> Document Number
                            </label>
                            <input 
                                type="text" 
                                class="form-control" 
                                name="docno" 
                                id="docno" 
                                placeholder="Enter Document Number" 
                                required
                                maxlength="14"
                            >
                            <div class="digit-counter" id="digitCounter">Entered: 0 digits</div>
                            <small class="text-muted" id="docnoHelp">Enter document number</small>
                        </div>
                        
                        <div class="mb-4" id="typeGroup" style="display: none;">
                            <label class="form-label">
                                <i class="fas fa-list"></i> Card Type
                            </label>
                            <select class="form-select" name="type" id="type">
                                <option value="old">Old Ration Card</option>
                                <option value="new">New Ration Card</option>
                            </select>
                        </div>
                        
                        <button type="submit" name="submit" class="btn btn-download" id="submitBtn">
                            <i class="fas fa-download"></i> Download PDF
                        </button>
                    </form>
                    
                    <!-- Info Box -->
                    <div class="info-box">
                        <p>
                            <i class="fas fa-info-circle"></i>
                            <strong>Note:</strong> Enter your Aadhaar or Ration number. The PDF will be downloaded automatically after successful payment deduction.
                        </p>
                    </div>
                </div>
            </div>
            
            <!-- Right Column: Preview -->
            <div class="col-lg-6">
                <div class="preview-container">
                    <h3 class="preview-title">PDF Preview</h3>
                    
                    <?php if ($pdfData): ?>
                        <!-- PDF Preview -->
                        <div class="preview-box">
                            <iframe 
                                src="data:application/pdf;base64,<?php echo $pdfData; ?>" 
                                width="100%" 
                                height="500px"
                                style="border-radius: 10px;"
                            ></iframe>
                            <div class="mt-4">
                                <a href="data:application/pdf;base64,<?php echo $pdfData; ?>" 
                                   class="btn btn-success" 
                                   download="Ration_<?php echo $application_no; ?>.pdf"
                                   style="padding: 12px 30px; border-radius: 10px; font-weight: 600;">
                                    <i class="fas fa-download"></i> Download PDF
                                </a>
                            </div>
                        </div>
                    <?php else: ?>
                        <!-- Empty Preview -->
                        <div class="preview-box">
                            <div class="preview-icon">
                                <i class="fas fa-file-pdf"></i>
                            </div>
                            <h4 style="color: #64748b; margin-bottom: 10px;">No PDF Preview Available</h4>
                            <p style="color: #94a3b8; text-align: center;">
                                Fill the form and submit to view the PDF preview here.
                            </p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const doctypeSelect = document.getElementById('doctype');
    const docnoInput = document.getElementById('docno');
    const docnoLabel = document.getElementById('docnoLabel');
    const docnoHelp = document.getElementById('docnoHelp');
    const typeGroup = document.getElementById('typeGroup');
    const digitCounter = document.getElementById('digitCounter');
    const submitBtn = document.getElementById('submitBtn');
    const form = document.getElementById('downloadForm');
    
    // Function to update digit counter
    function updateDigitCounter() {
        let value = docnoInput.value;
        // Remove spaces and count digits
        let digits = value.replace(/\D/g, '');
        let digitCount = digits.length;
        
        // Update counter
        digitCounter.textContent = 'Entered: ' + digitCount + ' digits';
        
        // Change color based on count
        digitCounter.className = 'digit-counter';
        if (doctypeSelect.value === 'aadhar') {
            if (digitCount === 12) {
                digitCounter.classList.add('success');
            } else if (digitCount > 12) {
                digitCounter.classList.add('error');
            } else if (digitCount >= 8) {
                digitCounter.classList.add('warning');
            }
        }
    }
    
    // Handle document type change
    doctypeSelect.addEventListener('change', function() {
        const doctype = this.value;
        
        if (doctype === 'aadhar') {
            docnoLabel.innerHTML = '<i class="fas fa-id-card"></i> Aadhaar Number';
            docnoInput.placeholder = '1234 5678 9012';
            docnoInput.type = 'text';
            docnoInput.maxLength = 14;
            docnoHelp.textContent = 'Enter 12-digit Aadhaar number';
            typeGroup.style.display = 'none';
        } else if (doctype === 'ration') {
            docnoLabel.innerHTML = '<i class="fas fa-file-invoice"></i> Ration Number';
            docnoInput.placeholder = 'Enter Ration Number';
            docnoInput.type = 'text';
            docnoInput.maxLength = 50;
            docnoHelp.textContent = 'Enter ration number';
            typeGroup.style.display = 'block';
        } else {
            docnoLabel.innerHTML = '<i class="fas fa-id-card"></i> Document Number';
            docnoInput.placeholder = 'Enter Document Number';
            typeGroup.style.display = 'none';
        }
        
        docnoInput.value = '';
        updateDigitCounter();
    });
    
    // Format Aadhaar input with spaces
    docnoInput.addEventListener('input', function() {
        const doctype = doctypeSelect.value;
        
        if (doctype === 'aadhar') {
            let value = this.value.replace(/\D/g, '');
            value = value.substring(0, 12);
            
            // Format with spaces: XXXX XXXX XXXX
            let formatted = '';
            if (value.length > 0) formatted = value.substring(0, 4);
            if (value.length > 4) formatted += ' ' + value.substring(4, 8);
            if (value.length > 8) formatted += ' ' + value.substring(8, 12);
            
            this.value = formatted;
        }
        
        updateDigitCounter();
    });
    
    // Form submission handling
    form.addEventListener('submit', function(e) {
        const doctype = doctypeSelect.value;
        let docno = docnoInput.value.trim();
        
        if (doctype === 'aadhar') {
            // Remove spaces for Aadhaar validation
            docno = docno.replace(/\s+/g, '');
            if (!/^[0-9]{12}$/.test(docno)) {
                e.preventDefault();
                Swal.fire({
                    icon: 'error',
                    title: 'Invalid Aadhaar Number',
                    text: 'Please enter exactly 12 digits',
                });
                docnoInput.focus();
                return false;
            }
        }
        
        // Show loading on button
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Processing...';
        submitBtn.disabled = true;
        
        return true;
    });
    
    // Initialize with default values
    doctypeSelect.value = 'aadhar';
    doctypeSelect.dispatchEvent(new Event('change'));
    docnoInput.value = '1234 5678 9012';
    updateDigitCounter();
});
</script>

</body>
</html>
